/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.GameWindow;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.opengl.Texture;
import util.ResourceManager;

public class Sprite {
    private Texture texture;
    private String filename;
    private int width;
    private int height;
    private float rotation;
    private float colorR;
    private float colorG;
    private float colorB;

    public Sprite(GameWindow window, String ref) {
        this.texture = ResourceManager.get().getTexture(ref);
        this.filename = ref.substring(ref.lastIndexOf(47) + 1);
        this.width = this.texture.getImageWidth();
        this.height = this.texture.getImageHeight();
        this.rotation = 0.0f;
        this.colorB = 1.0f;
        this.colorG = 1.0f;
        this.colorR = 1.0f;
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
    }

    public void rotate(float rotation) {
        this.rotation += rotation;
    }

    public void setColor(float r, float g, float b) {
        this.colorR = r;
        this.colorG = g;
        this.colorB = b;
    }

    public String getFilename() {
        return this.filename;
    }

    public int getWidth() {
        return this.texture.getImageWidth();
    }

    public int getHeight() {
        return this.texture.getImageHeight();
    }

    public void draw(int x, int y) {
        this.draw(x, y, this.width, this.height);
    }

    public void draw(int x, int y, int w, int h) {
        GL11.glPushMatrix();
        this.texture.bind();
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        if (this.rotation != 0.0f) {
            GL11.glTranslatef((float)(this.getWidth() / 2), (float)(this.getHeight() / 2), (float)0.0f);
            GL11.glRotatef((float)this.rotation, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)(-this.getWidth() / 2), (float)(-this.getHeight() / 2), (float)0.0f);
        }
        GL11.glColor3f((float)this.colorR, (float)this.colorG, (float)this.colorB);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)this.texture.getHeight());
        GL11.glVertex2f((float)0.0f, (float)h);
        GL11.glTexCoord2f((float)this.texture.getWidth(), (float)this.texture.getHeight());
        GL11.glVertex2f((float)w, (float)h);
        GL11.glTexCoord2f((float)this.texture.getWidth(), (float)0.0f);
        GL11.glVertex2f((float)w, (float)0.0f);
        GL11.glEnd();
        GL11.glPopMatrix();
    }
}

